<?php

function my_login_logo() {
  $logo = ( $user_logo = et_get_option( 'divi_logo' ) ) && '' != $user_logo
    ? $user_logo
    : get_stylesheet_directory_uri() . '/images/TechBear_login.png'; ?>
    <style type="text/css">
        #login h1 a, .login h1 a {
        background-image: url(<?php echo esc_attr( $logo ); ?>);
        height:120px;
        width:320px;
        background-size: 320px 120px;
        background-repeat: no-repeat;
        padding-bottom: 30px;
        }
    </style>
<?php }
add_action( 'login_enqueue_scripts', 'my_login_logo' );

function cc_mime_types($mimes) {
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
}
add_filter('upload_mimes', 'cc_mime_types');


function custom_footer_admin () {
echo 'Made by <a href="http://www.techbear.com" target="_blank">TechBear</a> | Built on <a href="http://www.wordpress.org" target="_blank">WordPress</a></p>';
}
add_filter('admin_footer_text', 'custom_footer_admin');

remove_action('welcome_panel', 'wp_welcome_panel');
add_filter('xmlrpc_enabled', '__return_false');

add_action('wp_dashboard_setup', 'my_custom_dashboard_widgets');

function my_custom_dashboard_widgets() {
global $wp_meta_boxes;

wp_add_dashboard_widget('custom_help_widget', 'Website Support', 'custom_dashboard_help');
}

function custom_dashboard_help() {
echo '<a style="display: block; width: 387px; margin: 0 auto;" href="https://techbear.com/" target="_blank"><img src="'. get_stylesheet_directory_uri() .'/images/TechBear_support.png"></a><h4>Your website is maintained by <a href="https://techbear.com/" target="_blank" style="color: #754198;font-weight:  bold;">TechBear</a>.</h4><p>If you need some help or if you encounter any problems, <br>you may contact us at , or send us email to:</p>
<p><a href="tel:2125172000" style="color: #754198; font-size: 20px; line-height: 20px;"><span class="dashicons dashicons-phone" style="color: #754198; padding-right: 10px; line-height: 20px;"> </span>212-517-2000</a></p>
<p><a href="mailto:support@techbear.com" style="color: #754198;font-size: 20px;line-height: 16px;"><span class="dashicons dashicons-email-alt" style="color: #754198; padding-right: 10px; line-height: 20px;"></span>support@techbear.com</a></p>';
}


require_once get_stylesheet_directory() . '/class-tgm-plugin-activation.php';
add_action( 'tgmpa_register', 'techbear_register_required_plugins' );

function techbear_register_required_plugins() {
	$plugins = array(
		array(
			'name'               => 'Ninja Forms', // The plugin name.
			'slug'               => 'ninja-forms', // The plugin slug (typically the folder name).
			'source'             => 'https://trythebear.com/plugins/ninja-forms.zip', // The plugin source.
			'required'           => false, // If false, the plugin is only 'recommended' instead of required.
			'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher. If the plugin version is higher than the plugin version installed, the user will be notified to update the plugin.
			'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
			'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
			'external_url'       => '', // If set, overrides default API URL and points to an external URL.
			'is_callable'        => '', // If set, this callable will be be checked for availability to determine if a plugin is active.
		),
    array(
      'name'               => 'Slider Revolution', // The plugin name.
      'slug'               => 'revslider', // The plugin slug (typically the folder name).
      'source'             => 'https://trythebear.com/plugins/codecanyon-2751380-slider-revolution-responsive-wordpress-plugin-wordpress-plugin.zip', // The plugin source.
      'required'           => false, // If false, the plugin is only 'recommended' instead of required.
      'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher. If the plugin version is higher than the plugin version installed, the user will be notified to update the plugin.
      'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
      'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
      'external_url'       => '', // If set, overrides default API URL and points to an external URL.
      'is_callable'        => '', // If set, this callable will be be checked for availability to determine if a plugin is active.
    ),
    array(
      'name'               => 'Easy Social Share Buttons', // The plugin name.
      'slug'               => 'easy-social-share-buttons', // The plugin slug (typically the folder name).
      'source'             => 'https://trythebear.com/plugins/codecanyon-6394476-easy-social-share-buttons-for-wordpress-wordpress-plugin.zip', // The plugin source.
      'required'           => false, // If false, the plugin is only 'recommended' instead of required.
      'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher. If the plugin version is higher than the plugin version installed, the user will be notified to update the plugin.
      'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
      'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
      'external_url'       => '', // If set, overrides default API URL and points to an external URL.
      'is_callable'        => '', // If set, this callable will be be checked for availability to determine if a plugin is active.
    ),
    array(
      'name'               => 'Divi Extended Column', // The plugin name.
      'slug'               => 'divi_extended_column', // The plugin slug (typically the folder name).
      'source'             => 'https://trythebear.com/plugins/divi_extended_column_layouts-12.zip', // The plugin source.
      'required'           => false, // If false, the plugin is only 'recommended' instead of required.
      'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher. If the plugin version is higher than the plugin version installed, the user will be notified to update the plugin.
      'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
      'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
      'external_url'       => '', // If set, overrides default API URL and points to an external URL.
      'is_callable'        => '', // If set, this callable will be be checked for availability to determine if a plugin is active.
    ),
    array(
      'name'               => 'Dp Owl Carousel Pro', // The plugin name.
      'slug'               => 'dp-owl-carousel-pro', // The plugin slug (typically the folder name).
      'source'             => 'https://trythebear.com/plugins/dp-owl-carousel-pro.zip', // The plugin source.
      'required'           => false, // If false, the plugin is only 'recommended' instead of required.
      'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher. If the plugin version is higher than the plugin version installed, the user will be notified to update the plugin.
      'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
      'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
      'external_url'       => '', // If set, overrides default API URL and points to an external URL.
      'is_callable'        => '', // If set, this callable will be be checked for availability to determine if a plugin is active.
    ),
    array(
      'name'               => 'Custom Fullwidth Header Extended', // The plugin name.
      'slug'               => 'dwd-custom-fullwidth-header-extended', // The plugin slug (typically the folder name).
      'source'             => 'https://trythebear.com/plugins/dwd-custom-fullwidth-header-extended.zip', // The plugin source.
      'required'           => false, // If false, the plugin is only 'recommended' instead of required.
      'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher. If the plugin version is higher than the plugin version installed, the user will be notified to update the plugin.
      'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
      'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
      'external_url'       => '', // If set, overrides default API URL and points to an external URL.
      'is_callable'        => '', // If set, this callable will be be checked for availability to determine if a plugin is active.
    ),
    array(
      'name'               => 'Map Extended', // The plugin name.
      'slug'               => 'dwd-map-extended', // The plugin slug (typically the folder name).
      'source'             => 'https://trythebear.com/plugins/dwd-map-extended.zip', // The plugin source.
      'required'           => false, // If false, the plugin is only 'recommended' instead of required.
      'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher. If the plugin version is higher than the plugin version installed, the user will be notified to update the plugin.
      'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
      'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
      'external_url'       => '', // If set, overrides default API URL and points to an external URL.
      'is_callable'        => '', // If set, this callable will be be checked for availability to determine if a plugin is active.
    ),
    array(
      'name'               => 'Yoast', // The plugin name.
      'slug'               => 'wordpress-seo', // The plugin slug (typically the folder name).
      'source'             => 'https://trythebear.com/plugins/wordpress-seo.7.7.zip', // The plugin source.
      'required'           => false, // If false, the plugin is only 'recommended' instead of required.
      'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher. If the plugin version is higher than the plugin version installed, the user will be notified to update the plugin.
      'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
      'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
      'external_url'       => '', // If set, overrides default API URL and points to an external URL.
      'is_callable'        => '', // If set, this callable will be be checked for availability to determine if a plugin is active.
    ),

	);
	$config = array(
		'id'           => 'techbear',                 // Unique ID for hashing notices for multiple instances of TGMPA.
		'default_path' => '',                      // Default absolute path to bundled plugins.
		'menu'         => 'tgmpa-install-plugins', // Menu slug.
		'parent_slug'  => 'themes.php',            // Parent menu slug.
		'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
		'has_notices'  => true,                    // Show admin notices or not.
		'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
		'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
		'is_automatic' => false,                   // Automatically activate plugins after installation or not.
		'message'      => '',                      // Message to output right before the plugins table.
	);

	tgmpa( $plugins, $config );
}
