<?php
/*
 * Shortcode Related Functionality
 *
 */

if( ! defined( 'ABSPATH' ) ) {
    exit ; // Exit if accessed directly.
}
if( ! class_exists( 'FP_GF_Shortcode_Functions' ) ) {

    /**
     * Shortcode Class.
     */
    final class FP_GF_Shortcode_Functions {

        public static function init() {
            //Available Short code pages
            add_action( 'wp_head' , array( __CLASS__ , 'frontend_custom_style' ) ) ;
        }

        public static function frontend_custom_style() {
            $custom_css = get_option( '_cf_frontend_custom_css_shortcode' , '' ) ;
            ?> <style type="text/css"> <?php
            echo $custom_css ;
            ?> </style> <?php
        }

        public static function common_function_for_progressbar( $post_id , $flag ) {
            //variable declaration
            $total_qty                      = '' ;
            $remainingdays                  = '' ;
            $sin_mul_remainingdays          = '' ;
            $remainingdaysleft_galaxyfunder = '' ;
            $checkinstock                   = FP_GF_Common_Functions::get_galaxy_funder_post_meta( $post_id , '_stock_status' ) ;
            //Get Target End selection
            $gettargetendselection          = FP_GF_Common_Functions::get_galaxy_funder_post_meta( $post_id , '_target_end_selection' ) ;

            //Get contributed amount
            $gettotalcontribution_goal       = fp_wpml_multi_currency( FP_GF_Common_Functions::get_galaxy_funder_post_meta( $post_id , '_crowdfundingtotalprice' ) ) ;
            $gettotalcontribution_goal_org   = fp_wpml_multi_currency( FP_GF_Common_Functions::get_galaxy_funder_post_meta( $post_id , '_crowdfundingtotalprice' ) ) ;
            $gettotalcontribution_goal_value = $gettotalcontribution_goal == '' ? '0' : $gettotalcontribution_goal ;
            $gettotalcontribution_goal       = FP_GF_Common_Functions:: format_price_in_proper_order( $gettotalcontribution_goal_value ) ;

            //Get target goal
            $gettargetgoal1      = FP_GF_Common_Functions::get_galaxy_funder_post_meta( $post_id , '_crowdfundinggettargetprice' ) ;
            $gettargetgoal       = fp_wpml_multi_currency( $gettargetgoal1 ) ;
            $gettargetgoal_value = $gettargetgoal == '' ? '0' : $gettargetgoal ;
            $gettargetgoal       = FP_GF_Common_Functions:: format_price_in_proper_order( $gettargetgoal , $gettargetgoal_value ) ;

            //Get percentage
            $getpercentage = FP_GF_Common_Functions::get_galaxy_funder_post_meta( $post_id , '_crowdfundinggoalpercent' ) ;

            //Get Total Funders
            $gettotalfunders_with_number = FP_GF_Common_Functions::get_galaxy_funder_post_meta( $post_id , '_update_total_funders' ) ;

            //Get minimum maximum labels
            $getminimumprice    = fp_wpml_multi_currency( FP_GF_Common_Functions::get_galaxy_funder_post_meta( $post_id , '_crowdfundinggetminimumprice' ) ) ;
            $getminimumprice    = $getminimumprice == '' ? '0' : $getminimumprice ;
            $getminbeforeformat = $getminimumprice ;
            $getmaximumprice    = fp_wpml_multi_currency( FP_GF_Common_Functions::get_galaxy_funder_post_meta( $post_id , '_crowdfundinggetmaximumprice' ) ) ;
            $getmaximumprice    = $getmaximumprice == '' ? '0' : $getmaximumprice ;
            $getmaxbeforeformat = $getmaximumprice ;
            $getminimumprice    = FP_GF_Common_Functions:: format_price_in_proper_order( $getminimumprice ) ;
            $getmaximumprice    = FP_GF_Common_Functions:: format_price_in_proper_order( $getmaximumprice ) ;

            //Get minimum maximum recommended prices
            $hideminimumprice = FP_GF_Common_Functions::get_galaxy_funder_post_meta( $post_id , '_crowdfundinghideminimum' ) ;
            $hidemaximumprice = FP_GF_Common_Functions::get_galaxy_funder_post_meta( $post_id , '_crowdfundinghidemaximum' ) ;
            $hidetargetprice  = FP_GF_Common_Functions::get_galaxy_funder_post_meta( $post_id , '_crowdfundinghidetarget' ) ;

            $hide_cf_field_in_shoppage = FP_GF_Common_Functions::get_galaxy_funder_post_meta( $post_id , 'hide_crowdfundingfield_shop_page' ) ;
            $hide_cf_value_in_shoppage = FP_GF_Common_Functions::get_galaxy_funder_post_meta( $post_id , 'hide_crowdfunding_value_in_shop' ) ;

            //Target Quantity check and functionalities
            if( $gettargetendselection == '5' ) {
                $total_qty     = get_post_meta( $post_id , '_crowdfundingquantity' , true ) ;
                $remaining_qty = get_post_meta( $post_id , 'remaining_qty' , true ) ;
                $saled_qty     = get_post_meta( $post_id , '_gf_saled_qty' , true ) ;
                if( $saled_qty != '' ) {
                    $saled_qty = $saled_qty ;
                } else {
                    $saled_qty = '0' ;
                }
                $count                         = $saled_qty / $total_qty ;
                $getpercentage                 = number_format( $count * 100 ) ;
                $gettargetgoal                 = $total_qty ;
                $gettotalcontribution_goal_org = $saled_qty ;
                $gettotalcontrinuted           = $saled_qty ;
                $goal_label                    = __( 'Quantity' , 'galaxyfunder' ) ;
            } else {
                $getpercentage       = FP_GF_Common_Functions::update_percentage_value( $gettargetgoal_value , $gettotalcontribution_goal_value , $post_id ) ;
                $goal_label          = __( 'Goal' , 'galaxyfunder' ) ;
                $gettotalcontrinuted = $gettotalcontribution_goal ;
            }
            $getpercentage_before_validate = $getpercentage == '' ? '0' : $getpercentage ;
            if( $getpercentage_before_validate > 100 ) {
                $progress_bar_getpercentage = 100 ;
            } else {
                $progress_bar_getpercentage = $getpercentage_before_validate ;
            }

            //Get Total Funders
            if( $gettotalfunders_with_number == '' ) {
                $gettotalfunders_with_number = 0 ;
            }

            $hide_cf_progessfield_css = $hide_cf_field_in_shoppage == "yes" ? 'margin-right:.5em' : '' ;

            $funders_label = get_option( 'cf_funder_label_shop' ) ;
            if( $gettotalfunders_with_number != '' ) {
                $gettotalfunders = '<span class="price" id="cf_get_total_funders" style="float:right;' . "$hide_cf_progessfield_css" . '">' . $gettotalfunders_with_number . '<small> ' . __( $funders_label , 'galaxyfunder' ) . '</small> </span>' ;
            } else {
                $gettotalfunders = '<span class="price" id="cf_get_total_funders"  style="float:right;' . "$hide_cf_progessfield_css" . '"> 0 <small>' . __( $funders_label , 'galaxyfunder' ) . '</small> </span>' ;
            }
            $currentfunderscount = '' ;
            if( get_option( 'cf_funders_count_show_hide_shop' ) == '1' ) {
                $currentfunderscount = $gettotalfunders ;
            }

            if( get_option( 'cf_day_left_show_hide_shop' ) == '1' ) {
                $remainingdaysleft_galaxyfunder = FP_GF_Common_Functions::common_function_to_find_day_difference( $post_id ) ;
            }


            $raisedamountshow     = '' ;
            $raisedpercentshow    = '' ;
            $daysleftshow         = '' ;
            $nooffundershow       = '' ;
            $description_position = '' ;
            if( $flag == 'shop' ) {
                $finalminimumpricelabel = get_option( 'crowdfunding_min_price_shop_page' ) ;
                $finalmaximumpricelabel = get_option( 'crowdfunding_maximum_price_shop_page' ) ;
                $targetpricelabel       = get_option( 'crowdfunding_target_price_shop_page' ) ;
                $totalpricelabel        = get_option( 'crowdfunding_totalprice_label_shop_page' ) ;
                $totalpricepercentlabel = get_option( 'crowdfunding_totalprice_percent_label_shop_page' ) ;
                $load_design            = get_option( 'load_inbuilt_shop_design' ) ;
                $progress_bar_type      = get_option( 'shop_page_prog_bar_type' ) ;
                if( get_option( 'cf_raised_amount_show_hide_shop' ) == 2 ) {
                    $raisedamountshow = 'no' ;
                }
                if( get_option( 'cf_raised_percentage_show_hide_shop' ) == 2 ) {
                    $raisedpercentshow = 'no' ;
                }
                if( get_option( 'cf_day_left_show_hide_shop' ) == 2 ) {
                    $daysleftshow = 'no' ;
                }
                if( get_option( 'cf_funders_count_show_hide_shop' ) == 2 ) {
                    $nooffundershow = 'no' ;
                }

                $description_position = get_option( 'crowdfunding_description_on_shop_page' ) ;
            } else if( $flag == 'shortcode' ) {
                $finalminimumpricelabel = get_option( 'crowdfunding_min_price_shop_page_shortcode' ) ;
                $finalmaximumpricelabel = get_option( 'crowdfunding_maximum_price_shop_page_shortcode' ) ;
                $targetpricelabel       = get_option( 'crowdfunding_target_price_shop_page_shortcode' ) ;
                $totalpricelabel        = get_option( 'crowdfunding_totalprice_label_shop_page_shortcode' ) ;
                $totalpricepercentlabel = get_option( 'crowdfunding_totalprice_percent_label_shop_page_shortcode' ) ;
                $load_design            = get_option( 'load_inbuilt_shop_design_shortcode' ) ;
                $progress_bar_type      = get_option( 'shortcode_page_prog_bar_type' ) ;
                if( get_option( 'cf_raised_amount_show_hide_shortcode' ) == 2 ) {
                    $raisedamountshow = 'no' ;
                }
                if( get_option( 'cf_raised_percentage_show_hide_shortcode' ) == 2 ) {
                    $raisedpercentshow = 'no' ;
                }
                if( get_option( 'cf_day_left_show_hide_shortcode' ) == 2 ) {
                    $daysleftshow = 'no' ;
                }
                if( get_option( 'cf_funders_count_show_hide_shortcode' ) == 2 ) {
                    $nooffundershow = 'no' ;
                }
            }

            $colon_symbol = " : " ;
            //Single product page labels
            if( $targetpricelabel != '' ) {
                $targetpricecaption = $targetpricelabel . $colon_symbol ;
            }

            if( $totalpricelabel != '' ) {
                $totalpricecaption = $totalpricelabel . $colon_symbol ;
            }

            if( $totalpricepercentlabel != '' ) {
                $totalpricepercentcaption = $totalpricepercentlabel . $colon_symbol ;
            }
            ?>
            <div class='' >
                <?php if( ($getminbeforeformat != 0) && ($hideminimumprice != 'yes') ) { ?>
                    <p id="cf_min_price_label" class="price">
                        <?php echo $finalminimumpricelabel ; ?> <?php echo $getminimumprice ; ?>
                    </p>
                <?php } if( ($getmaxbeforeformat != 0) && ($hidemaximumprice != 'yes') ) { ?>
                    <p id='cf_max_price_label' class="price">
                        <?php echo $finalmaximumpricelabel ; ?> <?php echo $getmaximumprice ; ?>
                    </p>
                <?php } ?>
            </div>
            <?php
            //Start of minimal style
            if( $load_design == 1 ) {

                if( $flag == 'shop' && $description_position == 'above_stylebar' ) {
                    echo FP_GF_Common_Functions::common_function_to_get_description( $post_id , $description_position ) ;
                }


                if( $hidetargetprice != 'yes' ) {
                    ?>
                    <p class="price" id="cf_target_price_label">
                        <label><?php echo $targetpricecaption ; ?> </label>
                        <span class="amount">
                            <span class="woocommerce-Price-amount amount"><?php echo $gettargetgoal ; ?></span>
                        </span>
                    </p>
                    <?php
                }
                if( $gettotalcontribution_goal_org != 0 && $raisedamountshow != 'no' ) {
                    ?>
                    <p class="price" id="cf_total_price_raised">
                        <label><?php echo $totalpricecaption ; ?>  </label>
                        <span class="amount">
                            <span class="woocommerce-Price-amount amount"><?php echo $gettotalcontribution_goal ; ?></span>
                        </span>
                    </p>
                    <?php
                }
                if( $raisedpercentshow != 'no' && $hide_cf_value_in_shoppage != 'yes' ) {
                    ?>
                    <p class="price" id="cf_total_price_in_percentage">
                        <label><?php echo $totalpricepercentcaption ; ?> </label>
                        <span class="amount"><?php echo $getpercentage_before_validate ; ?>%</span>
                    </p>
                    <?php
                }
            }

            if( $progress_bar_type == '1' && $load_design == 1 && $hide_cf_field_in_shoppage != 'yes' ) {
                ?>
                <div id="cf_total_price_in_percentage_with_bar" style="">
                    <div id="cf_percentage_bar" style="width: <?php echo $progress_bar_getpercentage ; ?>%;">&nbsp;</div>
                </div>
            <?php } ?>
            <?php if( $progress_bar_type == '2' && $load_design == 1 && $hide_cf_field_in_shoppage != 'yes' ) {
                ?>
                <div class="pledgetracker" style="clear:both;">
                    <span style="width: <?php echo $progress_bar_getpercentage ; ?>%;clear:both;">
                        <span class="currentpledgegoal"> </span>
                    </span>
                </div>

                <?php
            }

            if( $load_design == 1 && $flag == 'shop' && $description_position == 'below_stylebar' ) {
                echo FP_GF_Common_Functions::common_function_to_get_description( $post_id , $description_position ) ;
            }

            //End of minimal style
            //Start of ICG style
            if( $load_design == 2 && $flag == 'shop' && $description_position == 'above_stylebar' ) {
                echo FP_GF_Common_Functions::common_function_to_get_description( $post_id , $description_position ) ;
            }
            if( $progress_bar_type == '1' && $load_design == 2 ) {

                if( $hidetargetprice != 'yes' ) {
                    ?>
                    <p id="cf_total_price_raise" class="price" style="margin-bottom:0px;">
                        <span class="amount">
                            <span class="woocommerce-Price-amount amount">
                                <?php echo $gettargetgoal ; ?>
                            </span>
                        </span>
                    </p>
                <?php } if( $raisedpercentshow != 'no' && $hide_cf_value_in_shoppage != 'yes' ) { ?>
                    <p class="price" id="cf_total_raised_percentage" style=""><?php echo $getpercentage_before_validate ; ?>%</p>
                <?php } if( $hide_cf_field_in_shoppage != "yes" ) { ?>

                    <div id="cf_total_price_in_percent_with_bar" style="">
                        <div id="cf_percent_bar" style="width: <?php echo $progress_bar_getpercentage ; ?>%; clear:both;"></div>

                    </div>
                    <?php
                }
            }

            if( $progress_bar_type == '2' && $load_design == 2 ) {
                if( $hidetargetprice != 'yes' ) {
                    ?>
                    <p id="cf_total_price_raise" class="price" style="margin-bottom:0px;">
                        <span class="amount">
                            <span class="woocommerce-Price-amount amount">
                                <?php echo $gettargetgoal ; ?>
                            </span>
                        </span>
                    </p>
                <?php } if( $raisedpercentshow != 'no' && $hide_cf_value_in_shoppage != 'yes' ) { ?>
                    <p class="price" id="cf_total_raised_percentage" style=""><?php echo $getpercentage_before_validate ; ?>%</p>
                    <?php
                }
                if( $hide_cf_field_in_shoppage != 'yes' ) {
                    ?>
                    <div class="pledgetracker" style="clear:both;">
                        <span style="width: <?php echo $getpercentage_before_validate ; ?>%;clear:both;">
                            <span class="currentpledgegoal">
                            </span>
                        </span>
                    </div>

                    <?php
                }
            }

            if( $load_design == 2 ) {
                if( $daysleftshow != 'no' ) {
                    ?>
                    <p id="cf_price_new_date_remain" class="price">
                        <?php echo $remainingdaysleft_galaxyfunder ; ?>
                    </p>
                <?php } ?>
                <?php if( $nooffundershow != 'no' ) { ?>
                    <p class="price" id="cf_update_total_funders"> <?php echo $currentfunderscount ; ?> </p>
                    <?php
                }
            }
            if( $load_design == 2 && $flag == 'shop' && $description_position == 'below_stylebar' ) {
                echo FP_GF_Common_Functions::common_function_to_get_description( $post_id , $description_position ) ;
            }
            //End of ICG style
            //Start of KS style
            if( $load_design == 3 && $flag == 'shop' && $description_position == 'above_stylebar' ) {
                echo FP_GF_Common_Functions::common_function_to_get_description( $post_id , $description_position ) ;
            }
            if( $progress_bar_type == '1' && $load_design == 3 && $hide_cf_field_in_shoppage != 'yes' ) {
                ?>
                <div id="cf_total_price_in_percenter_with_bar" style="float:left">
                    <div id="cf_percenter_bar" style="width: <?php echo $progress_bar_getpercentage ; ?>%;"></div>
                </div>


                <?php
            }

            if( $progress_bar_type == '2' && $load_design == 3 && $hide_cf_field_in_shoppage != 'yes' ) {
                ?>
                <span class="pledgetracker" style="clear:both;">
                    <span style="width: <?php echo $progress_bar_getpercentage ; ?>%;clear:both;">
                        <span class="currentpledgegoal">
                        </span>
                    </span>
                </span>
                <?php
            }


            if( $load_design == 3 ) {
                if( $raisedpercentshow != 'no' && $hide_cf_value_in_shoppage != 'yes' ) {
                    ?>
                    <span id="cf_total_raised_in_percentage" class="price" style=""><?php echo $getpercentage_before_validate ; ?>%
                        <small> <?php echo __( ' RAISED' , 'galaxyfunder' ) ; ?></small>
                    </span>
                <?php } ?>
                <?php if( $gettotalcontribution_goal_org != 0 && $raisedamountshow != 'no' ) { ?>
                    <span id="cf_total_price_raiser" class="price"><?php echo $gettotalcontrinuted ; ?>
                        <small> <?php echo __( 'RAISED' ) ?> </small>
                    </span>
                    <?php
                }
                if( $daysleftshow != 'no' ) {
                    ?>
                    <span id="cf_days_remainings" class="price" style="float:left">
                        <?php echo $remainingdaysleft_galaxyfunder ; ?>
                    </span>
                    <?php
                }
            }
            if( $load_design == 3 && $flag == 'shop' && $description_position == 'below_stylebar' ) {
                echo FP_GF_Common_Functions::common_function_to_get_description( $post_id , $description_position ) ;
            }
            //Start of KS style
            ?>

            <div class='galaxy_funder_warning_message'></div>
            <?php
        }

        public static function update_percentage_value( $gettargetgoal , $getpledgedvalue , $product_id ) {
            if( ($getpledgedvalue != '') && ($gettargetgoal > 0) ) {
                $count1  = $getpledgedvalue / $gettargetgoal ;
                $count2  = $count1 * 100 ;
                $counter = number_format( $count2 , 0 ) ;
                $count   = $counter ;
            } else {
                $count = '0' ;
            }
            return $count ;
        }

    }

    FP_GF_Shortcode_Functions::init() ;
}
