jQuery(document).ready(function () {
    /*
     * Lightbox
     */
    jQuery(document).on('click', 'a.dp_ocp_lightbox_image', function () {
        var args = {
            type: 'image',
            removalDelay: 500,
            mainClass: 'mfp-fade dp-ocp-lightbox'
        };
        var dp_ocp_gallery_images = [];
        var dp_ocp_gallery_titles = [];
        var index = 0;
        var start_at = 0;
        var trigger_by = jQuery(this).attr('data-ref');
        if (jQuery(this).children('img').attr('data-lightbox-gallery') === 'on') {
            jQuery(this).parents('.owl-carousel').find('.dp_ocp_lightbox_image').each(function () {
                if (!jQuery(this).parents('.owl-item').hasClass('cloned')) {
                    if (trigger_by === jQuery(this).attr('data-ref')) {
                        start_at = index;
                    }
                    index++;
                    dp_ocp_gallery_images.push(jQuery(this).attr('data-ref'));
                    var title = jQuery(this).children('img').attr('title');
                    var alt = jQuery(this).children('img').attr('alt');
                    if (title !== undefined && title !== '') {
                        dp_ocp_gallery_titles.push(title);
                    } else if (alt !== undefined && alt !== '' && jQuery(this).children('img').hasClass('dp_oc_post_thumb')) {
                        dp_ocp_gallery_titles.push(alt);
                    }
                }
            });
            args['gallery'] = {enabled: true, navigateByImgClick: true};
        } else {
            dp_ocp_gallery_images.push(jQuery(this).attr('data-ref'));
            var title = jQuery(this).children('img').attr('title');
            var alt = jQuery(this).children('img').attr('alt');
            if (title !== undefined && title !== '') {
                dp_ocp_gallery_titles.push(title);
            } else if (alt !== undefined && alt !== '' && jQuery(this).children('img').hasClass('dp_oc_post_thumb')) {
                dp_ocp_gallery_titles.push(alt);
            }
        }
        for (var item in dp_ocp_gallery_images) {
            dp_ocp_gallery_images[item] = {'src': dp_ocp_gallery_images[item], 'title': dp_ocp_gallery_titles[item]};
        }
        args['items'] = dp_ocp_gallery_images;
        jQuery.magnificPopup.open(args, start_at);
        return false;
    });
    /*
     * Modal
     */
    if (typeof window.et_builder_version !== undefined) {
        /*
         * Vb Ajax modal for custom post type
         */
        var modal = '<div id="dp-ocp-vb-wrapper"><div id="dp-ocp-vb-modal"><div class="et-fb-loader-wrapper dp-ocp-vb-loader"><div class="et-fb-loader"></div></div></div></div>';
        jQuery(document).on('focus', '#et-fb-cpt_name', function () {
            if (isOcpVbModule(jQuery(this))) {
                var cpt_input = jQuery(this);
                var input_values = jQuery(this).val();
                if (input_values !== '') {
                    if (input_values.includes(',')) {
                        input_values = input_values.split(',');
                    } else {
                        input_values = [input_values];
                    }
                }
                if (jQuery('body').find('#dp-ocp-vb-wrapper').length === 0) {
                    jQuery('body').append(modal);
                    jQuery.ajax({
                        type: 'POST',
                        url: window.et_fb_options.ajaxurl,
                        data: {action: 'dpocp_get_cpt_action'}
                    }).done(function (data, textStatus, jqXHR) {
                        jQuery('.dp-ocp-vb-loader').remove();
                        jQuery('#dp-ocp-vb-modal').append(data);
                        jQuery('#dp-ocp-vb-modal').find('option').each(function () {
                            var opt_val = jQuery(this).val();
                            if (input_values.includes(opt_val)) {
                                jQuery(this).prop('selected', true);
                            }
                        });
                        jQuery('.dp-ocp-vb-submit').click(function () {
                            var cpt = jQuery('.dp-ocp-vb-select').val();
                            cpt_input.trigger('focus').val(cpt.join(',')).trigger('blur');
                            jQuery('.dp-ocp-vb-finish').click();
                        });
                        jQuery('.dp-ocp-vb-finish').click(function () {
                            jQuery('#dp-ocp-vb-wrapper').remove();
                        });
                        jQuery('.dp-ocp-vb-clean').click(function () {
                            cpt_input.trigger('focus').val('').trigger('blur');
                        });
                    }).fail(function (jqXHR, textStatus, errorThrown) {
                        jQuery('#dp-ocp-vb-modal').append(errorThrown);
                    });
                }
            }
        });
        /*
         * Vb Ajax modal for taxonomies
         */
        jQuery(document).on('focus', '#et-fb-taxonomy_tags', function () {
            if (isOcpVbModule(jQuery(this))) {
                var taxonomies_input = jQuery(this);
                var input_values = jQuery(this).val();
                var cpt = jQuery('#et-fb-cpt_name').val();
                if (input_values !== '') {
                    if (input_values.includes(',')) {
                        input_values = input_values.split(',');
                    } else {
                        input_values = [input_values];
                    }
                }
                if (jQuery('body').find('#dp-ocp-vb-wrapper').length === 0) {
                    jQuery('body').append(modal);
                    jQuery.ajax({
                        type: 'POST',
                        url: window.et_fb_options.ajaxurl,
                        data: {
                            action: 'dpocp_get_taxonomies_action',
                            cpt: (cpt === undefined || cpt === '') ? 'post' : cpt,
                        }
                    }).done(function (data, textStatus, jqXHR) {
                        jQuery('.dp-ocp-vb-loader').remove();
                        jQuery('#dp-ocp-vb-modal').append(data);
                        jQuery('#dp-ocp-vb-modal').find('option').each(function () {
                            var opt_val = jQuery(this).val();
                            if (input_values.includes(opt_val)) {
                                jQuery(this).prop('selected', true);
                            }
                        });
                        jQuery('.dp-ocp-vb-submit').click(function () {
                            var taxonomies = jQuery('.dp-ocp-vb-select').val();
                            taxonomies_input.trigger('focus').val(taxonomies.join(',')).trigger('blur');
                            jQuery('.dp-ocp-vb-finish').click();
                        });
                        jQuery('.dp-ocp-vb-finish').click(function () {
                            jQuery('#dp-ocp-vb-wrapper').remove();
                        });
                        jQuery('.dp-ocp-vb-clean').click(function () {
                            taxonomies_input.trigger('focus').val('').trigger('blur');
                        });
                    }).fail(function (jqXHR, textStatus, errorThrown) {
                        jQuery('#dp-ocp-vb-modal').append(errorThrown);
                    });
                }
            }
        });
        /*
         * Vb Ajax modal for include term
         */
        jQuery(document).on('focus', '#et-fb-cpt_categories, #et-fb-include_tags, #et-fb-exclude_tags', function () {
            if (isOcpVbModule(jQuery(this))) {
                var terms_input = jQuery(this);
                var input_values = jQuery(this).val();
                var cpt = jQuery('#et-fb-cpt_name').val();
                var tax = 'all';
                if (jQuery(this).prop('id') === 'et-fb-include_tags' || jQuery(this).prop('id') === 'et-fb-exclude_tags') {
                    tax = jQuery('#et-fb-taxonomy_tags').val();
                }
                if (input_values !== '') {
                    if (input_values.includes(',')) {
                        input_values = input_values.split(',');
                    } else {
                        input_values = [input_values];
                    }
                }
                if (jQuery('body').find('#dp-ocp-vb-wrapper').length === 0) {
                    jQuery('body').append(modal);
                    jQuery.ajax({
                        type: 'POST',
                        url: window.et_fb_options.ajaxurl,
                        data: {
                            action: 'dpocp_get_taxonomies_terms_action',
                            tax: (tax === undefined || tax === '') ? 'all' : tax,
                            cpt: (cpt === undefined || cpt === '') ? 'post' : cpt,
                        }
                    }).done(function (data, textStatus, jqXHR) {
                        jQuery('.dp-ocp-vb-loader').remove();
                        jQuery('#dp-ocp-vb-modal').append(data);
                        jQuery('#dp-ocp-vb-modal').find('option').each(function () {
                            var opt_val = jQuery(this).val();
                            if (input_values.includes(opt_val)) {
                                jQuery(this).prop('selected', true);
                            }
                        });
                        jQuery('.dp-ocp-vb-submit').click(function () {
                            var terms = jQuery('.dp-ocp-vb-select').val();
                            terms_input.trigger('focus').val(terms.join(',')).trigger('blur');
                            jQuery('.dp-ocp-vb-finish').click();
                        });
                        jQuery('.dp-ocp-vb-finish').click(function () {
                            jQuery('#dp-ocp-vb-wrapper').remove();
                        });
                        jQuery('.dp-ocp-vb-clean').click(function () {
                            terms_input.trigger('focus').val('').trigger('blur');
                        });
                    }).fail(function (jqXHR, textStatus, errorThrown) {
                        jQuery('#dp-ocp-vb-modal').append(errorThrown);
                    });
                }
            }
        });
        /*
         * 
         */
        jQuery(document).on('click', '#et-fb-thumbnail_size li.select-option-item', function () {
            if (jQuery(this).parents('.et-fb-form__toggle').attr('data-order') === '9') {
                var help = jQuery(this).parents('.et-fb-form__group').find('.et-fb-form__help');
                if (!help.hasClass('et-fb-form__help--active')) {
                    help.click();
                }
            }
        });
    }

    function isOcpVbModule(trigger) {
        var modal_title = trigger.parents(".et-fb-modal__content").siblings('.et-fb-modal__header').find('.et-fb-modal__title').text();
        if (modal_title.includes('DP Owl Carousel')) {
            return true;
        } else {
            return false;
        }
    }
});
