// External Dependencies
import React, { Component } from 'react';
import jQuery from 'jquery';

class DPOCP_ImageCarouselItemFW extends Component {

    static slug = 'et_pb_dp_oc_custom_fw_item';
    ts = 'et-pb-portfolio-image';
    aw = 'off';
    lg = 'off';
    is = "400x284";

    constructor(props) {
        super(props);
    }

    componentDidMount() {
    }

    componentDidUpdate(prevProps) {
    }

    render() {
        const moduleClass = this.props.moduleInfo.type + "_" + this.props.moduleInfo.order;
        this.ts = jQuery('.' + moduleClass).parents('.dpocp_carousel').attr('data-thumbnail-size');
        this.aw = jQuery('.' + moduleClass).parents('.dpocp_carousel').attr('data-auto-width');
        this.lg = jQuery('.' + moduleClass).parents('.dpocp_carousel').attr('data-lightbox-gallery');
        return (
            <div className="dp_oc_item">
                {this.renderImage()}
                {this.renderTitle()}
                {this.renderContent()}
            </div>
        );
    }

    getFileExtension(filename) {
        return filename.slice((filename.lastIndexOf(".") - 1 >>> 0) + 2);
    }

    getFileName(filename) {
        return filename.slice(0, filename.lastIndexOf("."));
    }

    renderImage() {
        if (this.props.upload_image !== undefined && this.props.upload_image !== '') {
            var image_url = this.props.upload_image;
            /*if (this.props.use_original === "on") {
                image_url = this.props.upload_image;
            } else {
                var name = this.getFileName(this.props.upload_image);
                var ext = this.getFileExtension(this.props.upload_image);
                image_url = name + "-" + this.is + "." + ext;
            }*/
            if (this.props.show_in_lightbox === "on") {
                return (
                    <a href="#" data-ref={this.props.upload_image} className="dp_ocp_lightbox_image" >
                        <img className="dp_oc_image_thumb" src={image_url} title={this.props.image_title_text} alt={this.props.image_alt_text} data-lightbox-gallery={this.lg} data-gallery-image={this.props.moduleInfo.order} />
                    </a>);
            } else if (this.props.url !== '') {
                return (
                    <a href={this.props.url} target={(this.props.url_new_window === 'on') ? "_blank" : ""}>
                        <img className="dp_oc_image_thumb" src={image_url} title={this.props.image_title_text} alt={this.props.image_alt_text} />
                    </a>
                );
            } else {
                return (
                    <img className="dp_oc_image_thumb" src={image_url} title={this.props.image_title_text} alt={this.props.image_alt_text} />
                );
            }
        } else {
            return null;
        }
    }

    renderTitle() {
        if (this.props.image_title !== '') {
            return (
                <h2 className="dp_oc_image_title">{this.props.image_title}</h2>
            );
        } else {
            return null;
        }
    }

    renderContent() {
        const Content = this.props.content;
        if (this.props.content !== '') {
            return (
                <div className="dp_oc_image_content">
                    <Content />
                </div>
            );
        } else {
            return null;
        }
    }

    /*runAjaxQuery() {
        var component = this;
        const props = this.props;
        const url = window.et_fb_options.ajaxurl;
        var imageProps = {
            'thumbnail_size': this.ts,
            'auto_width': this.aw,
            'upload_image': props.upload_image,
            'use_original': (props.use_original !== undefined) ? props.use_original : "off"
        };
        jQuery.ajax({
            type: 'POST',
            url: url,
            data: {
                action: 'get_image_data_action',
                module_props: imageProps
            }
        }).done(function (data, textStatus, jqXHR) { 
            component.setState({ imageData: JSON.parse(data) });
        }).fail(function (jqXHR, textStatus, errorThrown) {
        component.setState({  error: errorThrown });
        });
    }*/

}

export default DPOCP_ImageCarouselItemFW;
