// External Dependencies
import React, { Component } from 'react';
import jQuery from 'jquery';
import OwlCarousel from 'react-owl-carousel';
// Internal Dependencies
import './style.css';

class DPOCP_ImageCarousel extends Component {

    static slug = 'et_pb_dp_oc_custom';

    /*shouldComponentUpdate(nextProps, nextState) {
        console.log('PARENT');
        console.log(stringify(this.props));
        console.log(stringify(nextProps));
        console.log("parent:  " + stringify(this.props) !== stringify(nextProps));
        if (stringify(this.props) !== stringify(nextProps)) {
            return true;
        } else {
            return false;
        }
    }*/

    constructor(props) {
        super(props);
    }

    render() {
        const props = this.props;
        const responsive = { 0: { items: ('' === props.number_thumb_phone) ? 1 : props.number_thumb_phone }, 768: { items: ('' === props.number_thumb_tablet) ? 3 : props.number_thumb_tablet }, 981: { items: ('' === props.number_thumb) ? 5 : props.number_thumb } };
        return (
            <OwlCarousel
                data-thumbnail-size={props.thumbnail_size}
                data-auto-width={props.auto_width}
                data-lazy-load={props.lazy_load}
                data-lightbox-gallery={props.lightbox_gallery}
                className="dpocp_carousel"
                center={(props.center === 'on') ? true : false}
                rewind={(props.behavior === 'rewind') ? true : false}
                loop={(props.behavior === 'loop') ? true : false}
                nav={(props.show_arrow === 'on') ? true : false}
                URLhashListener={(props.use_hash_thumbnail === 'on') ? true : false}
                dots={(props.show_control === 'on' && props.use_hash_thumbnail !== 'on') ? true : false}
                dotsEach={(isNaN(props.items_per_dot)) ? 3 : parseInt(props.items_per_dot)}
                slideBy={(isNaN(props.items_per_slide)) ? 1 : parseInt(props.items_per_slide)}
                navText={["", ""]}
                margin={parseInt(props.item_margin)}
                autoplay={(props.slide_auto === 'on') ? false : false}
                autoplayTimeout={(isNaN(props.slide_speed)) ? 5000 : parseInt(props.slide_speed)}
                autoplaySpeed={(isNaN(props.animation_speed)) ? 500 : parseInt(props.animation_speed)}
                navSpeed={(isNaN(props.arrows_speed)) ? 500 : parseInt(props.arrows_speed)}
                dotsSpeed={(isNaN(props.dots_speed)) ? 500 : parseInt(props.dots_speed)}
                autoplayHoverPause={(props.slide_hover === 'on') ? true : false}
                autoWidth={(props.auto_width === 'on') ? true : false}
                lazyLoad={(props.lazy_load === 'on') ? true : false}
                responsiveRefreshRate={500}
                responsiveBaseElement={jQuery('.et-fb-mousetrap')}
                responsive={responsive}
            >
                {props.content}
            </OwlCarousel>
        );
    }

    static css(props) {
        const additionalCss = [{}];
        if (props.module_bg !== undefined && props.module_bg !== '') {
            additionalCss.push([{
                selector: '%%order_class%%.et_pb_dp_oc_custom .dp_oc_item',
                declaration: `background-color: ${props.module_bg};`
            }]);
        }
        if (props.arrow_color !== undefined && props.arrow_color !== '') {
            additionalCss.push([{
                selector: '%%order_class%%.et_pb_dp_oc_custom .owl-carousel .owl-nav',
                declaration: `color: ${props.arrow_color};`
            }]);
        }
        if (props.control_color !== undefined && props.control_color !== '') {
            additionalCss.push([{
                selector: '%%order_class%%.et_pb_dp_oc_custom .owl-carousel .owl-dots .owl-dot',
                declaration: `background-color: ${props.control_color};`
            }]);
        }
        if (props.control_size !== undefined && props.control_size !== '') {
            additionalCss.push([{
                selector: '%%order_class%%.et_pb_dp_oc_custom .owl-carousel .owl-dots .owl-dot',
                declaration: `width: ${props.control_size}; height: ${props.control_size};`
            }]);
        }
        if (props.show_arrow !== undefined && props.show_arrow !== 'on') {
            additionalCss.push([{
                selector: '%%order_class%%.et_pb_dp_oc_custom .owl-carousel .owl-nav',
                declaration: `display: none;`
            }]);
        }
        if (props.background_layout !== undefined) {
            if (props.background_layout === 'dark') {
                additionalCss.push([{
                    selector: '%%order_class%%, %%order_class%% a, %%order_class%% h2',
                    declaration: `color: #ffffff`
                }]);
                additionalCss.push([{
                    selector: '%%order_class%% .owl-dots .owl-dot',
                    declaration: `background-color: #ffffff`
                }]);
            } else {
                additionalCss.push([{
                    selector: '%%order_class%%, %%order_class%% a, %%order_class%% h2',
                    declaration: `color: #666666;`
                }]);
                additionalCss.push([{
                    selector: '%%order_class%% .owl-dots .owl-dot',
                    declaration: `background-color: #666666;`
                }]);
            }
        }
        return additionalCss;
    }
}

export default DPOCP_ImageCarousel;