<?php

class Dp_Owl_Carousel_Pro_Utils {

    public static function get_image_data($props) {
        $image_data = array();
        $image_size_width = '';
        $selected_size = (!isset($props['thumbnail_size']) || $props['thumbnail_size'] === "undefined") ? "et-pb-portfolio-image" : $props['thumbnail_size'];
        $selected_size_width = explode('x', self::get_custom_sizes()[$selected_size])[0];
        $auto_width = (!isset($props['auto_width']) || $props['auto_width'] === "undefined") ? "off" : $props['auto_width'];
        /*
         * 
         */
        if (isset($props['upload_image']) && !empty($props['upload_image'])) {
            $attachment_id = Dp_Owl_Carousel_Pro_Utils::get_attachment_id($props['upload_image']);
            if ($auto_width === 'on') {
                if ($props['use_original'] === 'on') {
                    $image_size_width = wp_get_attachment_metadata($attachment_id)['width'];
                } else {
                    $image_size_width = wp_get_attachment_metadata($attachment_id)['sizes'][$selected_size]['width'];
                    if ($image_size_width !== '') {
                        $image_size_width = $image_size_width;
                    } else {
                        $image_size_width = $selected_size_width;
                    }
                }
            }
            $image_src = "";
            if ($props['use_original'] === 'on') {
                $image_src = $props['upload_image'];
            } else {
                $image_src = wp_get_attachment_image_url($attachment_id, $selected_size);
            }
            $image_data['image_src'] = $image_src;
            $image_data['image_size_width'] = $image_size_width;
        } else {
            if ($auto_width === 'on') {
                $image_size_width = $selected_size_width;
            }
        }
        /*
         * 
         */
        return $image_data;
    }

    public static function get_carousel_items_data($props, $module_class) {
        /*
         * Init values
         */
        $posts_data = array();
        $posts_data['hash_thumbnail_array'] = array();
        $hash_thumbnail_counter = 0;
        $gallery_images = 0;
        if ($props['use_hash_thumbnail'] === 'on') {
            $props['show_control'] = 'off';
        }
        $selected_size_width = explode('x', self::get_custom_sizes()[$props['thumbnail_size']])[0];
        $default_size_width = explode('x', self::get_custom_sizes()['et-pb-portfolio-image'])[0];
        /*
         * 
         */
        $posts = new WP_Query(self::set_query_arguments($props));
        if ($posts->have_posts()) {
            while ($posts->have_posts()) {
                $posts->the_post();
                $data = array();
                $data['post_id'] = get_the_ID();
                $data['permalink'] = get_the_permalink();
                $data['has_thumbnail'] = has_post_thumbnail();
                $data['post_type'] = get_post_type();
                if ($data['has_thumbnail']) {
                    $thumbnail_id = get_post_thumbnail_id();
                }
                /*
                 * Get all custom field names and display as names
                 */
                $data['post_custom_fields'] = array();
                if (($props['custom_fields'] === 'on') && ($props['custom_field_names'] != '')) {
                    $custom_fields_array = self::process_comma_separate_list($props['custom_field_names']);
                    if ($props['custom_field_labels'] != '') {
                        $custom_fields_display = self::process_comma_separate_list($props['custom_field_labels']);
                        if (is_array($custom_fields_array) && is_array($custom_fields_display) && count($custom_fields_array) == count($custom_fields_display)) {
                            $custom_fields_array = array_combine($custom_fields_display, $custom_fields_array);
                            $data['post_custom_fields'] = self::dp_get_keyed_custom_fields($custom_fields_array, $data['post_id']);
                        } else {
                            $data['post_custom_fields'] = self::dp_get_custom_fields($custom_fields_array, $data['post_id']);
                        }
                    } else {
                        $data['post_custom_fields'] = self::dp_get_custom_fields($custom_fields_array, $data['post_id']);
                    }
                }
                /*
                 * Init item warp an activate data-hash navigation
                 */
                $data['data_hash'] = '';
                $data['data_hash_vb'] = '';
                if ($props['use_hash_thumbnail'] === 'on' && $data['has_thumbnail']) {
                    $data['data_hash'] = ' data-hash="' . trim($module_class) . '_' . $hash_thumbnail_counter . '" ';
                    $data['data_hash_vb'] = trim($module_class) . '_' . $hash_thumbnail_counter;
                    $hash_thumbnail_counter++;
                }
                /*
                 * Determine the image size width that will be apply to the item size
                 */
                $data['image_size_width'] = '';
                $data['image_vb'] = '';
                if ($props['auto_width'] === 'on') {
                    if ($props['thumbnail_original'] === 'on') {
                        if ($data['has_thumbnail']) {
                            $data['image_vb'] = wp_get_attachment_metadata($thumbnail_id)['width'];
                            $data['image_size_width'] = 'style="width: ' . $data['image_vb'] . 'px"';
                        } else {
                            $data['image_vb'] = $default_size_width;
                            $data['image_size_width'] = 'style="width: ' . $default_size_width . 'px"';
                        }
                    } else {
                        if ($data['has_thumbnail']) {
                            $width = wp_get_attachment_metadata($thumbnail_id)['sizes'][$props['thumbnail_size']]['width'];
                            if ($data['image_size_width'] !== '') {
                                $data['image_size_width'] = 'style="width: ' . $width . 'px"';
                                $data['image_vb'] = $width;
                            } else {
                                $data['image_size_width'] = 'style="width: ' . $selected_size_width . 'px"';
                                $data['image_vb'] = $selected_size_width;
                            }
                        } else {
                            $data['image_size_width'] = 'style="width: ' . $selected_size_width . 'px"';
                            $data['image_vb'] = $selected_size_width;
                        }
                    }
                }
                /*
                 * Add post thumbnail
                 */
                $data['gallery_id'] = '';
                if ($data['has_thumbnail']) {
                    if ($props['use_hash_thumbnail'] === 'on') {
                        $posts_data['hash_thumbnail_array'][] = get_the_post_thumbnail_url($data['post_id'], $props['hash_thumbnail_size']);
                    }
                    if ($props['thumbnail_original'] === 'on') {
                        $data['thumbnail'] = $data['thumbnail_original'] = get_the_post_thumbnail_url($data['post_id']);
                    } else {
                        $data['thumbnail'] = get_the_post_thumbnail_url($data['post_id'], $props['thumbnail_size']);
                        $data['thumbnail_original'] = get_the_post_thumbnail_url($data['post_id']);
                    }
                    if ($props['lightbox'] === 'on') {
                        $data['gallery_id'] = $gallery_images++;
                    }
                }
                /*
                 * Add post title, date, author and comments counts
                 */
                $data['title'] = get_the_title();
                $data['date'] = get_the_date();
                $data['author'] = get_the_author();
                $data['author_link'] = get_author_posts_url(get_post_field('post_author', $data['post_id']));
                $data['comments'] = sprintf(_nx('%s Comment', '%s Comments', get_comments_number(), 'number of comments', DPOCP_NAME), number_format_i18n(get_comments_number()));
                /*
                 * Add post terms
                 */
                $data['categories'] = array();
                $taxonomies = get_post_taxonomies();
                foreach ($taxonomies as $tax) {
                    if (is_taxonomy_hierarchical($tax)) {
                        $terms = get_the_terms($data['post_id'], $tax);
                        if ($terms) {
                            foreach ($terms as $term) {
                                $term_data['url'] = get_term_link($term);
                                $term_data['name'] = $term->name;
                                $data['categories'][] = $term_data;
                            }
                        }
                    }
                }
                /*
                 * Add post excerpts
                 */
                $data['excerpt'] = apply_filters('dp_ocp_custom_excerpt', self::custom_excerpt($props), $props);
                /*
                 * Add custom_content
                 */
                $data['custom_content'] = apply_filters('dp_ocp_custom_content', "", $props);
                /*
                 * Add post data
                 */
                $posts_data['posts'][] = $data;
            }
        } else {
            $posts_data['no_results'] = apply_filters('dp_ocp_no_results', sprintf('%1$s', __('No posts found', DPOCP_NAME)));
        }
        wp_reset_postdata();
        return $posts_data;
    }

    public static function set_query_arguments($props) {
        $args = array();
        if ('on' == $props['custom_query']) {
            $args = self::dp_ocp_custom_query();
        } else {
            $args['posts_per_page'] = intval($props['number_post']);
            if (is_user_logged_in()) {
                $args['post_status'] = array('publish', 'private');
            } else {
                $args['post_status'] = array('publish');
            }
            if (!empty($props['offset_number'])) {
                $args['offset'] = intval($props['offset_number']);
            }
            if (!empty($props['cpt_name'])) {
                $args['post_type'] = self::process_comma_separate_list($props['cpt_name']);
            } else {
                $args['post_type'] = array('post');
            }
            $tax_query = array();
            if (!empty($props['cpt_categories'])) {
                $post_categories = self::process_comma_separate_list($props['cpt_categories']);
                $taxonomies_terms = self::get_taxonomies_terms_array($post_categories);
                foreach ($taxonomies_terms as $tax => $terms) {
                    $tax_query[] = array(
                        'taxonomy' => $tax,
                        'field' => 'term_id',
                        'terms' => $terms,
                    );
                }
                if (count($tax_query) >= 2) {
                    $tax_query['relation'] = 'OR';
                }
            }
            if ($props['taxonomy_tags'] === '') {
                $props['taxonomy_tags'] = 'post_tag';
            }
            $tag_query = array();
            if (!empty($props['include_tags'])) {
                $tag_query[] = array(
                    'taxonomy' => $props['taxonomy_tags'],
                    'field' => 'term_id',
                    'terms' => explode(',', $props['include_tags']),
                    'operator' => 'IN'
                );
            }
            if (!empty($props['exclude_tags'])) {
                $tag_query[] = array(
                    'taxonomy' => $props['taxonomy_tags'],
                    'field' => 'term_id',
                    'terms' => explode(',', $props['exclude_tags']),
                    'operator' => 'NOT IN'
                );
            }
            if (count($tag_query) >= 2) {
                $tag_query['relation'] = 'AND';
            }
            if (!empty($tax_query) && empty($tag_query)) {
                $args['tax_query'] = $tax_query;
            } else if (empty($tax_query) && !empty($tag_query)) {
                $args['tax_query'] = $tag_query;
            } else if (!empty($tax_query) && !empty($tag_query)) {
                $args['tax_query'][] = $tax_query;
                $args['tax_query'][] = $tag_query;
                $args['tax_query']['relation'] = 'AND';
            }
            $args['orderby'] = $props['orderby'];
            $args['order'] = $props['order'];
            if ($props['remove_current_post'] === 'on' && is_single()) {
                $args['post__not_in'] = array($post_id);
            }
        }
        return $args;
    }

    public static function get_taxonomies_terms_array($terms) {
        $taxonomies_terms = array();
        foreach ($terms as $term_id) {
            $taxonomy = get_term($term_id)->taxonomy;
            if (!isset($taxonomies_terms[$taxonomy])) {
                $taxonomies_terms[$taxonomy] = array();
                array_push($taxonomies_terms[$taxonomy], $term_id);
            } else {
                array_push($taxonomies_terms[$taxonomy], $term_id);
            }
        }
        return $taxonomies_terms;
    }

    public static function et_strip_shortcodes($content) {
        $content = trim($content);
        $strip_content_shortcodes = array('et_pb_code', 'et_pb_fullwidth_code',);
        foreach ($strip_content_shortcodes as $shortcode_name) {
            $regex = sprintf('(\[%1$s[^\]]*\][^\[]*\[\/%1$s\])', esc_html($shortcode_name));
            $content = preg_replace($regex, '', $content);
        }
        $content = preg_replace('(\[[^\]]+\])', '', $content);
        return $content;
    }

    public static function custom_excerpt($props) {
        if (has_excerpt()) {
            return get_the_excerpt();
        } else {
            $post_content = get_the_content();
            // remove caption shortcode from the post content
            $post_content = preg_replace('@\[caption[^\]]*?\].*?\[\/caption]@si', '', $post_content);
            // remove post nav shortcode from the post content
            $post_content = preg_replace('@\[et_pb_post_nav[^\]]*?\].*?\[\/et_pb_post_nav]@si', '', $post_content);
            // Remove audio shortcode from post content to prevent unwanted audio file on the excerpt
            // due to unparsed audio shortcode
            $post_content = preg_replace('@\[audio[^\]]*?\].*?\[\/audio]@si', '', $post_content);
            // Remove embed shortcode from post content
            $post_content = preg_replace('@\[embed[^\]]*?\].*?\[\/embed]@si', '', $post_content);
            // Remove scripts from the post content
            $post_content = wp_kses_post(html_entity_decode($post_content));
            $post_content = self::et_strip_shortcodes($post_content);
            if (isset($props['post_excerpt_length']) && intval($props['post_excerpt_length'])) {
                return self::truncate_content($post_content, $props['post_excerpt_length']);
            } else {
                return $post_content;
            }
        }
    }

    public static function truncate_content($excerpt, $excerpt_limit) {
        $charlength = $excerpt_limit;
        $charlength++;
        if (mb_strlen($excerpt) > $charlength) {
            $subex = mb_substr($excerpt, 0, $charlength - 5);
            $exwords = explode(' ', $subex);
            $excut = - ( mb_strlen($exwords[count($exwords) - 1]) );
            if ($excut < 0) {
                return mb_substr($subex, 0, $excut) . '...';
            } else {
                return $subex;
            }
        } else {
            return $excerpt;
        }
    }

    public static function get_custom_sizes() {
        $options = array();
        global $_wp_additional_image_sizes;
        foreach (get_intermediate_image_sizes() as $_size) {
            if (in_array($_size, array('thumbnail', 'medium', 'medium_large', 'large'))) {
                $sizes[$_size]['width'] = get_option("{$_size}_size_w");
                $sizes[$_size]['height'] = get_option("{$_size}_size_h");
            } elseif (isset($_wp_additional_image_sizes[$_size])) {
                $sizes[$_size] = array(
                    'width' => $_wp_additional_image_sizes[$_size]['width'],
                    'height' => $_wp_additional_image_sizes[$_size]['height'],
                );
            }
            $options[$_size] = $sizes[$_size]['width'] . "x" . $sizes[$_size]['height'];
        }
        return $options;
    }

    public static function dp_ocp_custom_query() {
        $args = apply_filters('dp_ocp_custom_query_args', array('posts_per_page' => 10, 'post_type' => 'post', 'post_status' => 'publish'));
        return $args;
    }

    public static function dp_get_custom_fields($custom_fields_array, $post_id) {
        foreach ($custom_fields_array as $field_display) {
            $custom_field = trim($field_display);
            $field_display = ucfirst(str_replace('_', ' ', ltrim($field_display)));
            $field_display .= ' - ';
            $post_custom_fields[$field_display] = get_post_meta($post_id, $custom_field, true);
        }
        return $post_custom_fields;
    }

    public static function dp_get_keyed_custom_fields($custom_fields_array, $post_id) {
        foreach ($custom_fields_array as $field_display => $field_value) {
            $custom_field = trim($field_value);
            $post_custom_fields[$field_display] = get_post_meta($post_id, $custom_field, true);
        }
        return $post_custom_fields;
    }

    public static function process_comma_separate_list($list) {
        $array = explode(',', $list);
        if (is_array($array)) {
            foreach ($array as $key => $value) {
                $array[$key] = trim($value);
            }
        }
        return $array;
    }

    public static function get_cpt() {
        $options = array();
        $default_post_type = apply_filters('dpocp_default_post_types', array('post' => get_post_type_object('post')));
        $post_types = array_merge($default_post_type, get_post_types(array('_builtin' => false, 'public' => true), 'objects'));
        foreach ($post_types as $pt) {
            $options[$pt->name] = $pt->label;
        }
        return $options;
    }

    public static function ajax_get_cpt() {
        ob_start();
        echo '<form id="dp-ocp-cpt-form">';
        echo sprintf('<p>%1$s</p>', __('Select one or more post types below. Use CTRL or SHIFT to select multiple.', DPOCP_NAME));
        echo '<select class="dp-ocp-vb-select" name="dp-ocp-vb-select" multiple size="6">';
        foreach (self::get_cpt() as $key => $cpt) {
            echo sprintf('<option value="%1$s">%2$s</option>', $key, $cpt);
        }
        echo '</select>';
        self::vb_modal_actions();
        echo '</form';
        echo ob_get_clean();
        wp_die();
    }

    public static function get_taxonomies($cpt) {
        $options = array();
        $blacklisted_taxonomies = apply_filters('dpocp_blacklisted_taxonomies', array('layout_category', 'layout_pack', 'layout_type', 'scope', 'module_width', 'post_format'));
        $taxonomies = array_diff(get_taxonomies(array('public' => true, 'query_var' => true)), $blacklisted_taxonomies);
        if ($cpt[0] === 'all') {
            foreach ($taxonomies as $tax) {
                $tax_obj = get_taxonomy($tax);
                $options[$tax] = $tax_obj->label;
            }
        } else {
            foreach ($taxonomies as $tax) {
                $tax_obj = get_taxonomy($tax);
                $is_there = array_intersect($cpt, $tax_obj->object_type);
                if (!empty($is_there)) {
                    $options[$tax] = $tax_obj->label;
                }
            }
        }
        return $options;
    }

    public static function ajax_get_taxonomies() {
        $cpt_array = array('post');
        if (isset($_POST['cpt'])) {
            if (substr_count($_POST['cpt'], ',') > 0) {
                $cpt_array = self::process_comma_separate_list($_POST['cpt']);
            } else {
                $cpt_array = array($_POST['cpt']);
            }
        }
        ob_start();
        echo '<form id="dp-ocp-tax-form">';
        echo sprintf('<p>%1$s</p>', __('Select one or more taxonomies below. Use CTRL or SHIFT to select multiple.', DPOCP_NAME));
        echo '<select class="dp-ocp-vb-select" name="dp-ocp-vb-select" multiple size="6">';
        foreach (self::get_taxonomies($cpt_array) as $key => $tax) {
            echo sprintf('<option value="%1$s">%2$s</option>', $key, $tax);
        }
        echo '</select>';
        self::vb_modal_actions();
        echo '</form';
        echo ob_get_clean();
        wp_die();
    }

    public static function get_taxonomies_terms($tax, $cpt) {
        $options = array();
        $all_cpt_taxonomies = self::get_taxonomies($cpt);
        if ($tax[0] === 'all') {
            foreach ($all_cpt_taxonomies as $tax_name => $tax_label) {
                $terms = array();
                foreach (get_terms(array('taxonomy' => $tax_name)) as $term) {
                    $terms[$term->term_id] = $term->name;
                }
                $options[$tax_name . " (" . $tax_label . ")"] = $terms;
            }
        } else {
            foreach ($all_cpt_taxonomies as $tax_name => $tax_label) {
                if (in_array($tax_name, $tax)) {
                    $terms = array();
                    foreach (get_terms(array('taxonomy' => $tax_name)) as $term) {
                        $terms[$term->term_id] = $term->name;
                    }
                    $options[$tax_name . " (" . $tax_label . ")"] = $terms;
                }
            }
        }
        return $options;
    }

    public static function ajax_get_taxonomies_terms() {
        $tax_array = array('category');
        if (isset($_POST['tax'])) {
            if (substr_count($_POST['tax'], ',') > 0) {
                $tax_array = self::process_comma_separate_list($_POST['tax']);
            } else {
                $tax_array = array($_POST['tax']);
            }
        }
        $cpt_array = array('post');
        if (isset($_POST['cpt'])) {
            if (substr_count($_POST['cpt'], ',') > 0) {
                $cpt_array = self::process_comma_separate_list($_POST['cpt']);
            } else {
                $cpt_array = array($_POST['cpt']);
            }
        }
        ob_start();
        echo '<form id="dp-ocp-terms-form">';
        echo sprintf('<p>%1$s</p>', __('Select one or more terms below. Use CTRL or SHIFT to select multiple.', DPOCP_NAME));
        echo '<select class="dp-ocp-vb-select" name="dp-ocp-vb-select" multiple size="12">';
        foreach (self::get_taxonomies_terms($tax_array, $cpt_array) as $tax => $terms) {
            echo '<optgroup label="' . $tax . '">';
            foreach ($terms as $term_id => $term_name) {
                echo sprintf('<option value="%1$s">%2$s</option>', $term_id, $term_name);
            }
            echo '</optgroup>';
        }
        echo '</select>';
        self::vb_modal_actions();
        echo '</form';
        echo ob_get_clean();
        wp_die();
    }

    public static function vb_modal_actions() {
        echo '<div class="dp-ocp-vb-actions">';
        echo sprintf('<input class="dp-ocp-vb-submit" type="button" value="%1$s" />', __('Set Values', DPOCP_NAME));
        echo sprintf('<input class="dp-ocp-vb-clean" type="button" value="%1$s" />', __('Clean Values', DPOCP_NAME));
        echo sprintf('<input class="dp-ocp-vb-finish" type="button" value="%1$s" />', __('Exit', DPOCP_NAME));
        echo '</div>';
    }

    /**
     * Get an attachment ID given a URL.
     * 
     * @param string $url
     * @since 2.0
     * @return int Attachment ID on success, 0 on failure
     */
    public static function get_attachment_id($url) {
        $attachment_id = 0;
        $dir = wp_upload_dir();
        if (false !== strpos($url, $dir['baseurl'] . '/')) {
            $file = basename($url);
            $query_args = array(
                'post_type' => 'attachment',
                'post_status' => 'inherit',
                'fields' => 'ids',
                'meta_query' => array(
                    array(
                        'value' => $file,
                        'compare' => 'LIKE',
                        'key' => '_wp_attachment_metadata',
                    ),
                )
            );
            $query = new WP_Query($query_args);
            if ($query->have_posts()) {
                foreach ($query->posts as $post_id) {
                    $meta = wp_get_attachment_metadata($post_id);
                    $original_file = basename($meta['file']);
                    $cropped_image_files = wp_list_pluck($meta['sizes'], 'file');
                    if ($original_file === $file || in_array($file, $cropped_image_files)) {
                        $attachment_id = $post_id;
                        break;
                    }
                }
            }
            wp_reset_postdata();
        }
        /*
         * Fallback to old method
         */
        if($attachment_id===0){
            global $wpdb;
            $attachment_id = $wpdb->get_var($wpdb->prepare("SELECT ID FROM $wpdb->posts WHERE post_type='attachment' AND guid='%s';", $url));
        }
        return $attachment_id;
    }

}
