<?php

/** * 
 * Plugin Name: DP Owl Carousel Pro
 * Plugin URI: http://www.diviplugins.com/divi/owl-carousel-pro-plugin/
 * Description: Adds two new modules to the Divi Builder. One module creates a carousel from posts and custom post types. The other module creates a carousel from images you add. The Pro version adds support for Custom Post Types, custom query, change thumbnail size, change number of images shown at once, open image in lightbox, and display custom fields.
 * Version: 2.0.3
 * Author: DiviPlugins
 * Author URI: http://www.diviplugins.com
 * License: GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain: dpocp-dp-owl-carousel-pro
 * Domain Path: /languages
 */
// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

define('DPOCP_NAME', 'dpocp-dp-owl-carousel-pro');
define('DPOCP_VERSION', '2.0.3');
define('DPOCP_DIR', plugin_dir_path(__FILE__));
define('DPOCP_URL', plugin_dir_url(__FILE__));
define('DPOCP_LICENSE_PAGE', 'dp_ocp_license');
define('DPOCP_STORE_URL', 'https://diviplugins.com/');
define('DPOCP_ITEM_NAME', 'Owl Carousel Pro');
define('DPOCP_ITEM_ID', '4541');

/**
 * The code that runs during plugin activation. This action is documented in includes/class-dp-owl-carousel-pro-activator.php
 */
function activate_dp_owl_carousel_pro() {
    require_once DPOCP_DIR . 'includes/class-dpocp-activator.php';
    Dp_Owl_Carousel_Pro_Activator::activate();
}

register_activation_hook(__FILE__, 'activate_dp_owl_carousel_pro');

/**
 * The code that runs during plugin deactivation. This action is documented in includes/class-dp-owl-carousel-pro-deactivator.php
 */
function deactivate_dp_owl_carousel_pro() {
    require_once DPOCP_DIR . 'includes/class-dpocp-deactivator.php';
    Dp_Owl_Carousel_Pro_Deactivator::deactivate();
}

register_deactivation_hook(__FILE__, 'deactivate_dp_owl_carousel_pro');

/**
 * The core plugin class that is used to define internationalization, admin-specific hooks, and public-facing site hooks.
 */
require DPOCP_DIR . 'includes/class-dpocp.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks, then kicking off the plugin from this point in the file does not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_dp_owl_carousel_pro() {
    $plugin = new Dp_Owl_Carousel_Pro();
    $plugin->run();
}

run_dp_owl_carousel_pro();